package cn.com.duiba.live.clue.service.api.enums.conf.form;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

/**
 * 表单字段类型枚举
 *
 * @author xuzhigang
 * @date 2020/7/25 6:10 下午
 **/
@Getter
@AllArgsConstructor
public enum FormFieldTypeEnum {

    NAME(1, "姓名"),

    PHONE(2, "手机号"),

    EMAIL(3, "邮箱"),

    SINGLE_LINE_TEXT (4, "填空"),

    SINGLE_SELECT(5, "单选"),

    MULTIPLE_SELECT(6, "多选"),

    ;

    private static final List<Integer> SELECT_TYPE_LIST = new ArrayList<>();

    static {
        SELECT_TYPE_LIST.add(SINGLE_SELECT.type);
        SELECT_TYPE_LIST.add(MULTIPLE_SELECT.type);
    }

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 是否是选择题类型
     * @param type 字段类型
     * @return true-是，false-否
     */
    public static boolean isSelectType(Integer type) {
        if (type == null) {
            return false;
        }
        return SELECT_TYPE_LIST.contains(type);
    }
}
