package cn.com.duiba.live.clue.service.api.enums.conf.form;

import cn.com.duiba.live.clue.service.api.dto.conf.form.OptionTypeResolverResultDTO;
import com.alibaba.fastjson.JSONObject;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.Collections;
import java.util.List;

/**
 * 描述：表单评测-问题的选项类型
 *
 * @author zhouziwu
 * @date 2022-05-13
 */
@Getter
@AllArgsConstructor
public enum PubFormOptionTypeEnum {


    /** 纯文案选项 */
    STRING_OPTION(0, "", "纯文案选项"),

    /** 图文选项 */
    PICTURE_OPTION(1, "PIC-", "图文选项"),
    ;

    /** 编号 */
    private final Integer code;

    /** 前缀 */
    private final String prefix;

    /** 描述 */
    private final String desc;

    /**
     * 解析optionTitle字段
     * @param optionTitle 选项内容
     * @return 解析结果
     */
    public static OptionTypeResolverResultDTO optionTitleResolver(String optionTitle) {
        if (StringUtils.isBlank(optionTitle)) {
            return new OptionTypeResolverResultDTO(STRING_OPTION.getCode(), Collections.singletonList(optionTitle));
        }
        if (optionTitle.startsWith(PICTURE_OPTION.getPrefix())) {
            String jsonString = optionTitle.substring(PICTURE_OPTION.getPrefix().length());
            List<String> strings = JSONObject.parseArray(jsonString, String.class);
            return new OptionTypeResolverResultDTO(PICTURE_OPTION.getCode(), strings);
        }
        return new OptionTypeResolverResultDTO(STRING_OPTION.getCode(), Collections.singletonList(optionTitle));
    }
}
