package cn.com.duiba.live.clue.service.api.enums.conf.goods;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 直播秒杀-高级玩法类型
 *
 * @author ZhangJun
 * @date 2021/12/10 11:29 上午
 */
@Getter
@AllArgsConstructor
public enum LiveSecondKillPlayTypeEnum {

    NONE(0, "无配置"),
    QUALIFICATION(1, "秒杀资格"),
    COUPONS(2, "秒杀优惠券"),
    ;

    /**
     * 玩法类型
     */
    private Integer playType;

    /**
     * 玩法描述
     */
    private String desc;

    private static final Map<Integer, LiveSecondKillPlayTypeEnum> ENUM_MAP;

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(LiveSecondKillPlayTypeEnum.values()).collect(Collectors.toMap(LiveSecondKillPlayTypeEnum::getPlayType, Function.identity())));
    }

    public static LiveSecondKillPlayTypeEnum getByType(Integer playType) {
        if (playType == null) {
            return null;
        }
        return ENUM_MAP.get(playType);
    }

}
