package cn.com.duiba.live.clue.service.api.enums.conf.live;

import cn.com.duiba.live.clue.service.api.util.NumberUtil;
import com.google.common.collect.Maps;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Map;

/**
 * 猜数字红包-发放类型
 *
 * @author ZhangJun
 * @date 2021/6/7 7:31 下午
 */
@Getter
@AllArgsConstructor
public enum LiveGuessRedSendTypeEnum {

    /**
     * 猜数字红包-固定金额
     */
    FIX_AMOUNT(1, "固定金额"),

    /**
     * 猜数字红包-瓜分总额
     */
    PARTITION_AMOUNT(2, "瓜分金额"),
    ;

    /**
     * 发放类型,1-固定金额，2-瓜分金额
     */
    private final Integer sendType;

    /**
     * 类型描述
     */
    private final String desc;

    private static final Map<Integer, LiveGuessRedSendTypeEnum> ENUM_MAP = Maps.newHashMap();

    static {
        for (LiveGuessRedSendTypeEnum item : LiveGuessRedSendTypeEnum.values()) {
            ENUM_MAP.put(item.getSendType(), item);
        }
    }

    /**
     * 判断是否包含该枚举类型
     */
    public static boolean contains(Integer sendType) {
        if (NumberUtil.isNullOrLteZero(sendType)) {
            return false;
        }
        return ENUM_MAP.containsKey(sendType);
    }

    /**
     * 获取对应的枚举实例
     */
    public static LiveGuessRedSendTypeEnum getEnumItem(Integer sendType) {
        if (NumberUtil.isNullOrLteZero(sendType)) {
            return null;
        }
        return ENUM_MAP.get(sendType);
    }

}
