package cn.com.duiba.live.clue.service.api.enums.conf.live;

import cn.com.duiba.live.clue.service.api.util.NumberUtil;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zhuenhui
 * @date 2022/11/18 10:23
 * @description 预告页 - 抽奖任务类型
 */
@Getter
@AllArgsConstructor
public enum LivePreLotteryTaskType {

    ALL_TASK(1, "全部任务（含分享、保存海报、关注等）"),
    ONLY_SHARE(2, "只保留分享（主推裂变）"),
    ;

    private static final Map<Integer, LivePreLotteryTaskType> ENUM_MAP = Collections.unmodifiableMap(
            Arrays.stream(values()).collect(Collectors.toMap(
                    LivePreLotteryTaskType::getType,
                    Function.identity(),
                    (v1, v2) -> v2
            ))
    );

    public static LivePreLotteryTaskType getByType(Integer type) {
        if (NumberUtil.isNullOrLteZero(type)) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    private final Integer type;
    private final String desc;
}
