package cn.com.duiba.live.clue.service.api.enums.conf.live;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.collections4.ListUtils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 直播资料类型
 * 和直播互动配置表保持统一。这里是tb_resource表存储的类型集合
 * @see cn.com.duiba.live.clue.service.api.enums.conf.conf.LiveInteractTypeEnum
 */
@Getter
@AllArgsConstructor
public enum LiveResourceTypeEnum {

    MATERIAL(1,"图文资料"),
    LINK_RESOURCE(9,"链接资料"),
    OA_RESOURCE(10,"公众号资料"),
    FREE_RESOURCE(11, "免费领资料"),
    FORM_RESOURCE(12, "表单资料"),
    TEST_RESOURCE(13,"测试资料"),
    GAME_RESOURCE(14,"小游戏资料"),
    EVALUATION_RESOURCE(23, "测评资料"),
    ;

    private static final List<Integer> ALL_TYPES = ListUtils.unmodifiableList(Arrays.stream(LiveResourceTypeEnum.values()).map(LiveResourceTypeEnum::getType).collect(Collectors.toList()));

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 判断是否是tb_resource表的资料
     * @param type 类型 可以是tb_resource表或者tb_interact_conf表的type
     */
    public static boolean isResourceInteract(Integer type){
        return ALL_TYPES.contains(type);
    }

}
