package cn.com.duiba.live.clue.service.api.enums.conf.live;

import com.google.common.collect.Lists;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 直播状态
 * @author lizhi
 * @date 2020/3/30 3:27 PM
 */
public enum LiveStatusApiEnum {
    LIVE_NOTICE(1, "未开始"),
    LIVE_PROCESSING(2, "直播中"),
    LIVE_INTERRUPT(3, "断网"),
    DATA_STATISTIC_ING(4, "数据统计中"),
    DATA_STATISTIC_END(5, "数据统计完成"),
    DATA_STATISTIC_FAILED(6, "数据统计失败,定时任务自动重试"),
    LIVE_NOT_SHELF(7, "未上架"),
    ;

    /**
     * 结束状态
     */
    public static final List<Integer> END_STATUS = Collections.unmodifiableList(Lists.newArrayList(4, 5, 6));
    /**
     * 未结束的状态
     */
    public static final List<Integer> NOT_OVER_STATUS =Collections.unmodifiableList(Lists.newArrayList(1,2,3));
    /**
     * 正在直播的状态
     */
    public static final List<Integer> LIVING_STATUS =Collections.unmodifiableList(Lists.newArrayList(2,3));

    /**
     * 开始的且没有彻底结束（4 :统计中也是未彻底结束）
     */
    public static final List<Integer> START_AND_NOT_END = Collections.unmodifiableList(Lists.newArrayList(2,3,4));

    /**
     * 统计未结束所有的直播
     */
    public static final List<Integer> START_AND_ALL_NOT_END = Collections.unmodifiableList(Lists.newArrayList(1,2,3,4,7));


    private Integer code;

    private String desc;

    LiveStatusApiEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, LiveStatusApiEnum> ENUM_MAP = new HashMap<>();



    static{
        for(LiveStatusApiEnum statusEnum : values()){
            ENUM_MAP.put(statusEnum.getCode(), statusEnum);
        }
    }

    public static LiveStatusApiEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public static boolean isEnd(Integer code) {
        LiveStatusApiEnum statusEnum = getByCode(code);
        if (statusEnum == null) {
            return false;
        }
        return statusEnum.equals(DATA_STATISTIC_ING) || statusEnum.equals(DATA_STATISTIC_END)
                || statusEnum.equals(DATA_STATISTIC_FAILED);
    }

    /**
     * 直播是否已开始
     *
     * @param code 枚举值
     * @return true-已开始 false-未开始
     */
    public static boolean isStarted(Integer code) {
        return !(LIVE_NOTICE.getCode().equals(code) || LIVE_NOT_SHELF.getCode().equals(code));
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
