package cn.com.duiba.live.clue.service.api.enums.conf.livestream;

import java.util.Objects;

/**
 * @author dugq
 * @date 2020-09-20 23:59
 */
public enum LiveStreamPlatformEnum {
    ALIYUN(1,"阿里云"),
    TENCENT(2,"腾讯云");

    private Integer code;
    private String desc;

    LiveStreamPlatformEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static LiveStreamPlatformEnum getByCode(Integer code) {
        if (Objects.isNull(code)){
            return null;
        }
        for (LiveStreamPlatformEnum enumVal : LiveStreamPlatformEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }
}
