package cn.com.duiba.live.clue.service.api.enums.conf.mall;

import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Collections;
import java.util.List;

/**
 * 商城业务场景
 *
 * @author xuzhigang
 * @date 2022/8/9 2:11 下午
 **/
@Getter
@AllArgsConstructor
public enum MallBizTypeEnum {

    /**
     * 对应bizId: liveId
     */
    LIVE(1, "直播场景"),
    /**
     * 对应bizId: 办卡活动id
     */
    BANK_APPLY_ACTIVITY(2, "银行办卡活动场景"),
    /**
     * 对应bizId: liveId
     */
    LIVE_ACTIVITY(3, "直播活动"),
    /**
     * 对应bizId: 公司id
     */
    COMPANY_HOME(4, "公司主页商品"),
    /**
     * 对应bizId: liveId
     */
    LIVE_NEWCOMERS(5, "直播中-新人专享"),
    /**
     * 对应bizId: 营销活动id
     */
    MARKETING_ACTIVITY(6, "营销活动"),
    ;

    private final Integer code;

    private final String desc;

    /**
     * todo 对应bizId是直播id的业务场景 会影响到退库存的逻辑，所以如果是这种场景这边要加一下，然后更新版本到clue-center
     */
    public static final List<Integer> LIVE_TYPE_LIST = Collections.unmodifiableList(Lists.newArrayList(LIVE.code, LIVE_ACTIVITY.code, LIVE_NEWCOMERS.code));
}
