package cn.com.duiba.live.clue.service.api.enums.conf.mall.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zhuenhui
 * @date 2022/09/15 15:32
 * @description 商城 - 优惠券状态
 */
@Getter
@AllArgsConstructor
public enum MallCouponStatusEnum {

    WAIT_DISTRIBUTE(1, "未发放"),
    DISTRIBUTING(2, "发放中"),
    MANUAL_INVALID(3, "手动失效"),
    LIVE_END_INVALID(4, "直播结束自动失效"),

    ;
    private final Integer status;
    private final String desc;

    /**
     * 优惠券最终状态
     */
    public static final List<Integer> END_STATUS_LIST = Collections.unmodifiableList(Arrays.asList(
            MANUAL_INVALID.getStatus(),
            LIVE_END_INVALID.getStatus()
    ));

    private static final Map<Integer, MallCouponStatusEnum> ENUM_MAP = Collections.unmodifiableMap(
            Arrays.stream(values()).collect(Collectors.toMap(
                    MallCouponStatusEnum::getStatus,
                    Function.identity(),
                    (v1, v2) -> v2
            ))
    );

    public static MallCouponStatusEnum getByStatus(Integer type) {
        return ENUM_MAP.get(type);
    }


    private static final List<Integer> CAN_USE_STATUS = Arrays.asList(1,2);

    //用户是否可以使用
    public boolean canUse(){
        return CAN_USE_STATUS.contains(this.status);
    }

    public static boolean canUse(Integer status){
        if (Objects.isNull(status)){
            return false;
        }
        return CAN_USE_STATUS.contains(status);
    }

    //用户是否可以领取
    public static boolean canReceive(Integer status){
        return Objects.equals(status,DISTRIBUTING.getStatus());
    }


}
