package cn.com.duiba.live.clue.service.api.enums.conf.mall.salegoods;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author xuzhigang
 * @date 2023/6/6 10:54
 **/
@Getter
@AllArgsConstructor
public enum LimitRegionTypeEnum {
    NOT_LIMIT(1, "不限制地区"),

    LIMIT_REGION_BUY(2, "限制地区购买"),

    LIMIT_REGION_NOT_BUY(3, "限制地区不能购买"),

    ;

    private final int type;

    private final String desc;

    private static final Map<Integer, LimitRegionTypeEnum> map = new HashMap<>();

    static {
        for (LimitRegionTypeEnum value : values()) {
            map.put(value.type, value);
        }
    }

    public static LimitRegionTypeEnum getByType(Integer type) {
        return map.get(type);
    }
}
