package cn.com.duiba.live.clue.service.api.enums.conf.mall.salegoods.related;

import cn.com.duiba.live.clue.service.api.enums.conf.mall.MallBizTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 商品关联业务类型
 * @author lizhi
 * @date 2023/3/7 11:57 上午
 */
@Slf4j
@Getter
@AllArgsConstructor
public enum GoodsListRelatedBizTypeEnum {
    LIVE_NEWCOMERS(1, MallBizTypeEnum.LIVE_NEWCOMERS, "直播中-新人专享", "tb_live.id"),
    COMPANY_HOME(2, MallBizTypeEnum.COMPANY_HOME, "公司主页商品", "tb_live_company.id"),
    MARKETING_ACTIVITY(3, MallBizTypeEnum.MARKETING_ACTIVITY, "营销活动商品", "tb_mall_marketing_activity.id")
    ;

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 对应的售卖商品枚举
     */
    private final MallBizTypeEnum mallBizTypeEnum;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 业务ID关联说明
     */
    private final String bizIdDesc;

    private static final Map<Integer, GoodsListRelatedBizTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(GoodsListRelatedBizTypeEnum::getType, Function.identity(), (v1, v2) -> {
        log.error("GoodsListRelatedBizTypeEnum, type distinct, v1.name={}, v2.name={}", v1.name(), v2.name());
        return v2;
    })));

    public static GoodsListRelatedBizTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
