package cn.com.duiba.live.clue.service.api.enums.conf.mall.salegoods.related;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 商品关联业务类型
 * @author lizhi
 * @date 2023/3/7 11:57 上午
 */
@Slf4j
@Getter
@AllArgsConstructor
public enum GoodsListRelatedExtEnum {

    NEWCOMERS_LIMIT(1, "新人限购", "0-不限购，1-限购，枚举：cn.com.duiba.live.clue.service.api.enums.conf.BooleanEnum"),
    /**
     * {@link GoodsListLimitTypeEnum}
     */
    MARKETING_ACTIVITY_LIMIT(2, "营销活动商品限购", "1-不限购 2-新人专享")
    ;

    /**
     * 类型
     */
    private final Integer code;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 配置值说明
     */
    private final String valueDesc;

    private static final Map<Integer, GoodsListRelatedExtEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(GoodsListRelatedExtEnum::getCode, Function.identity(), (v1, v2) -> {
        log.error("GoodsListRelatedExtEnum, code distinct, v1.name={}, v2.name={}", v1.name(), v2.name());
        return v2;
    })));

    public static GoodsListRelatedExtEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
}
