package cn.com.duiba.live.clue.service.api.enums.conf.pass;

import java.util.HashMap;
import java.util.Map;

/**
 * 闯关答题问题状态
 * @author chentiecheng
 * @date 2021/6/21 3:08 下午
 */
public enum LivePassQuesStatusEnum {
    NOT_BEGIN(0,"未开始"),
    BEGINNING(1,"答题中"),
    END(2,"已结束"),
    ;

    /**
     * 状态
     */
    private Integer status;
    /**
     * 描述
     */
    private String desc;

    LivePassQuesStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }
    private static final Map<Integer, LivePassQuesStatusEnum> ENUM_MAP = new HashMap<>();

    static{
        for(LivePassQuesStatusEnum typeEnums : values()){
            ENUM_MAP.put(typeEnums.getStatus(), typeEnums);
        }
    }

    /**
     * 根据状态获取枚举
     * @param status 状态
     * @return 状态枚举
     */
    public static LivePassQuesStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }


    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }
}
