package cn.com.duiba.live.clue.service.api.enums.conf.pass;

import java.util.HashMap;
import java.util.Map;

/**
 * 闯关答题红包发放状态
 * @author chentiecheng
 * @date 2021/6/21 3:08 下午
 */
public enum LivePassRedStatusEnum {
    NOT_SHELF(0,"待上架"),
    NOT_BEGIN(1,"待瓜分"),
    BEGINNING(2,"瓜分中"),
    END(3,"结束"),
    ;

    /**
     * 状态
     */
    private Integer status;
    /**
     * 描述
     */
    private String desc;

    LivePassRedStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    private static final Map<Integer, LivePassRedStatusEnum> ENUM_MAP = new HashMap<>();

    static{
        for(LivePassRedStatusEnum typeEnums : values()){
            ENUM_MAP.put(typeEnums.getStatus(), typeEnums);
        }
    }

    /**
     * 根据状态获取枚举
     * @param status 状态
     * @return 状态枚举
     */
    public static LivePassRedStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }
    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }
}
