package cn.com.duiba.live.clue.service.api.enums.conf.red;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zhuenhui
 * @date 2021/08/30 10:44
 * @description 直播红包 - 发放方式类型枚举
 */
@Getter
@AllArgsConstructor
public enum LiveRedDeliverModeTypeEnum {

    MANUAL(1, "手动"),
    AUTO(2, "自动"),
    ;

    private static final Map<Integer, LiveRedDeliverModeTypeEnum> ENUM_MAP = Collections.unmodifiableMap(
            Arrays.stream(values()).collect(Collectors.toMap(LiveRedDeliverModeTypeEnum::getType, Function.identity()))
    );

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 根据类型获取枚举
     */
    public static LiveRedDeliverModeTypeEnum getByType(Integer type) {
        return ENUM_MAP.get(type);
    }

}
