package cn.com.duiba.live.clue.service.api.enums.conf.treasure;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author zhuenhui
 * @date 2021/04/13 2:23 下午
 * @description 宝箱场景类型枚举
 */
@Getter
@AllArgsConstructor
public enum TreasureSceneTypeEnum {

    /**
     * 宝箱场景，业务维度
     */
    FISSION_TREASURE(1, "裂变宝箱"),
    STAY_TREASURE(2, "停留时长宝箱"),
    GOLDEN_EGG_TREASURE(3, "砸金蛋"),
    ;

    /**
     * 宝箱类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    private static final Map<Integer, TreasureSceneTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(TreasureSceneTypeEnum typeEnums : values()){
            ENUM_MAP.put(typeEnums.getType(), typeEnums);
        }
    }

    public static TreasureSceneTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}