package cn.com.duiba.live.clue.service.api.param.conf.conf;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 互动内容查询
 * @author 吴文哲
 * @date 2020-04-02 15:05
 **/
@Data
public class LiveInteractConfQueryParam implements Serializable {

    private static final long serialVersionUID = -4628198815810845397L;

    /**
     * 直播id
     */
    private Long liveId;

    /**
     * 互动类型
     * @see cn.com.duiba.live.clue.service.api.enums.conf.conf.LiveInteractTypeEnum
     */
    private Integer interactType;

    /**
     * 互动类型 集合
     * @see cn.com.duiba.live.clue.service.api.enums.conf.conf.LiveInteractTypeEnum
     */
    private List<Integer> interactTypes;

    /**
     * 互动状态
     * @see cn.com.duiba.live.clue.service.api.enums.conf.conf.InteractStatusEnums
     */
    private Integer interactStatus;

    /**
     * 互动状态 集合
     * @see cn.com.duiba.live.clue.service.api.enums.conf.conf.InteractStatusEnums
     */
    private List<Integer> interactStatusList;

    /**
     * 排序方式
     * @see cn.com.duiba.live.clue.service.api.enums.conf.conf.LiveInteractSortEnum
     */
    private int sort;

    /**
     * 配置类型
     * @see cn.com.duiba.live.clue.service.api.enums.conf.conf.InteractTypeEnums
     */
    private Integer confType;
}
