package cn.com.duiba.live.clue.service.api.param.conf.livestream;

import lombok.Data;

import java.io.Serializable;

/**
 * Created by dugq on 2020-03-27.
 */
@Data
public class InsertAppParam implements Serializable {
    private static final long serialVersionUID = -3050253248581344462L;

    private Long id;

    /**
     *app名称
     * max length = 50
     * not null default = null
     */
    private String appName;

    /**
     * 业务放方类型。和ID 1对1
     * 如果未来业务场景无法再 1对1 了，就需要业务方存储app ID
     * 后续创建直播 需要根据app ID作为参数
     */
    private Integer bizType;

    /**
     * 推流域名
     * max length = 50
     * not null default = null
     */
    private String pushDomain;

    /**
     * 拉流域名
     * max length = 50
     * not null default = null
     */
    private String pullDomain;
    /**
     * 使用平台。
     * 1： 阿里云
     * 2： 腾讯云
     * {@link cn.com.duiba.live.clue.service.api.enums.conf.livestream.LiveStreamPlatformEnum }
     */
    private Integer platform;


}
