package cn.com.duiba.live.clue.service.api.param.conf.mall.goods;

import cn.com.duiba.live.clue.service.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 商城-商品库分页查询参数
 *
 * @author kjj mybatis generator 
 * @date 2022-07-27
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MallGoodsEsSearchParam extends PageQuery {


    private static final long serialVersionUID = -1393100475461703362L;
    /**
     * id
     */
    private Long id;

    /**
     * 供应商id，tb_supplier.id
     */
    private Long supplierId;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 商品类目id，tb_goods_category.id
     */
    private Long categoryId;

    /**
     * 市场指导价，由选品规格决定，单位：分
     */
    private Long marketPriceLow;

    /**
     * 市场指导价，由选品规格决定，单位：分
     */
    private Long marketPriceHigh;

    /**
     * 最低建议售价，由选品规格决定，单位：分
     */
    private Long suggestPriceLow;

    /**
     * 最高建议售价，由选品规格决定，单位：分
     */
    private Long suggestPriceHigh;

    /**
     * 商品状态
     */
    private Integer goodsStatus;

    /**
     * 入库状态
     * @see cn.com.duiba.live.clue.service.api.enums.conf.mall.goods.pick.PickStatusEnum
     */
    private Integer pickStatus;

    /**
     * 选品活动id，tb_pick_activity.id
     */
    private Long pickActivityId;

    /**
     * 是否删除，0=false，1=true
     * @see cn.com.duiba.live.clue.service.api.enums.conf.BooleanEnum
     */
    private Integer deleted;

}