package cn.com.duiba.live.clue.service.api.param.conf.mall.salegoods;

import cn.com.duiba.live.clue.service.api.dto.conf.mall.salegoods.MallSaleSpuExtDto;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 商品编辑参数
 *
 * @author ZhangJun
 * @date 2022/7/25 19:24
 */
@Data
public class SaleGoodsUpdateMngParam implements Serializable {

    private static final long serialVersionUID = -7690553806745600821L;

    /**
     * spuId
     */
    private Long spuId;

    /**
     * 直播商品id = spuId
     * 请使用spuId
     */
    @Deprecated
    private Long liveGoodsId;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 品牌名
     */
    private String goodsBrand;

    /**
     * 商品描述
     */
    private String goodsDesc;

    /**
     * 主图id集合
     */
    private List<Long> mainImgIds;

    /**
     * 商品小程序分享图
     */
    private String mpShareImg;

    /**
     * 详情图id集合
     */
    private List<Long> detailImgIds;

    /**
     * 商品详情页文本描述
     */
    private String detailWords;

    /**
     * 发货地
     */
    private String deliveryPlace;

    /**
     * 发货物流
     */
    private String expressCompany;

    /**
     * 是否支持七天无理由退货
     * 0=否，1=是
     * {@link cn.com.duiba.live.clue.service.api.enums.conf.BooleanEnum}
     */
    private Integer noReasonRefund;

    /**
     * 退换货地址等信息
     */
    private String refundInfo;

    /**
     * 发货审核设置
     * 0=否，1=是
     * {@link cn.com.duiba.live.clue.service.api.enums.conf.BooleanEnum}
     */
    private Integer deliveryAudit;

    /**
     * 最大购买限制
     */
    private Integer maxBuyNum;

    /**
     * 限制地区代码
     */
    private String limitRegionCode;

    /**
     * 限制地区名称
     */
    private String limitRegionName;

    /**
     * 商品地区限制类型 1-不限制地区 2-限制指定地区可够买 3-限制指定地区不可购买
     * {@link cn.com.duiba.live.clue.service.api.enums.conf.mall.salegoods.LimitRegionTypeEnum}
     */
    private Integer limitRegionType;

    /**
     * 橱窗按钮标题文案
     */
    private String buttonTitle;

    /**
     * 主标签 图片url
     */
    private String mainTag;

    /**
     * 配送方式 1-订单配送 2-线下自送
     */
    private Integer deliveryWay;

    /**
     * 副标签
     */
    private List<String> subTag;

    /**
     * 支付渠道
     */
    private List<Integer> payChannels;

    /**
     * 支持的银行编码
     */
    private List<String> restrictedBankCodes;

    /**
     * 持卡判断限制
     * 1-不限制 2-仅持卡人购买 3-仅非持卡人购买
     * {@link cn.com.duiba.live.clue.service.api.enums.conf.card.BankCardHoldLimitType}
     */
    private Integer cardHoldLimit;



    /**
     * 是否开启微信银行卡支付自动审核1：开启0：关闭
     */
    private Integer autoAudit;

    /**
     * 微信银行卡自动审核银行code列表
     */
    private List<String> wxRestrictedBankCodes;

    /**
     * 分期期数
     */
    private Integer installmentsNum;

    /**
     * 拼团配置
     */
    private MallSaleSpuExtDto.GroupConfDto groupConf;

    /**
     * 包邮类型 {@link cn.com.duiba.live.clue.service.api.enums.conf.mall.salegoods.FreeDeliveryTypeEnum}
     */
    private Integer freeDelivery;

    /**
     * 邮费配置
     */
    private List<MallSaleSpuExtDto.DeliveryFeeConfDto> deliveryFeeConfList;
}
