package cn.com.duiba.live.clue.service.api.param.conf.ques;

import cn.com.duiba.live.clue.service.api.dto.conf.common.CommonQuestionDto;
import cn.com.duiba.live.clue.service.api.dto.conf.common.CommonQuestionOptionDto;
import cn.com.duiba.live.clue.service.api.dto.conf.conf.LiveInteractConfDto;
import cn.com.duiba.live.clue.service.api.dto.conf.red.LiveConfRedPacketDto;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 直播答题奖品编辑参数
 * @author 吴文哲
 * @date 2021/3/21 2:51 下午
 **/
@Data
public class LiveQuesRewardConfEditParam implements Serializable {
    private static final long serialVersionUID = -6848901826675829184L;


    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 答题领奖配置id
     */
    private Long confId;

    /**
     * 奖品类型 1:答题送红包 2:答题送奖品
     * @see cn.com.duiba.live.clue.service.api.enums.conf.conf.QuestionRewardTypeEnum
     */
    private Integer quesType;

    /**
     * 代理人领取类型 0:不能领取 1:可以领取
     * 默认0:不能领取
     * @see cn.com.duiba.live.clue.service.api.enums.conf.BooleanEnum
     */
    private Integer agentReceiveType;

    /**
     * 答题领奖品配置
     */
    private LiveInteractConfDto welfareEditDto;

    /**
     * 答题领红包配置
     */
    private LiveConfRedPacketDto redEditDto;

    /**
     * 抽奖券数量 配置
     */
    private Integer lotteryNum;

    /**
     * 问题
     */
    private CommonQuestionDto commonQuestionDto;

    /**
     * 问题选项集合
     */
    private List<CommonQuestionOptionDto> commonQuestionOptionDtoList;

    /**
     * 是否支持邀请，0:不支持，1:支持
     * 默认 1:支持
     * @see cn.com.duiba.live.clue.service.api.enums.conf.BooleanEnum
     */
    private Integer supportInvite;

}
