package cn.com.duiba.live.clue.service.api.param.conf.salegoods;

import cn.com.duiba.live.clue.service.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;

/**
 * 商城-售卖规格库存单元表
 * @author kjj mybatis generator 
 * @date 2022-08-09
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class MallSaleSkuSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16600253495446557L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 售卖商品id tb_mall_sale_spu.id
     */
    private Long spuId;

    /**
     * 商品库规格库存id，tb_mall_goods_sku.id
     */
    private Long goodsSkuId;

    /**
     * sku图片
     */
    private String skuImg;

    /**
     * 售价
     */
    private Integer discountedPrice;

    /**
     * 市场价
     */
    private Integer marketPrice;

    /**
     * 总库存
     */
    private Integer totalStock;

    /**
     * 剩余库存
     */
    private Integer surplusStock;

    /**
     * 规格属性配置json，格式为keyId:valueId，如{1:2,3:4}，key为tb_attribute_key.id，value为tb_attribute_value.id
     */
    private String attributeConfig;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}