package cn.com.duiba.live.clue.service.api.param.conf.salegoods;

import cn.com.duiba.live.clue.service.api.enums.conf.mall.salegoods.GoodsTypeEnum;
import cn.com.duiba.live.clue.service.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;

/**
 * 商城-售卖商品表
 * @author kjj mybatis generator 
 * @date 2022-08-09
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class MallSaleSpuSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16600253495424228L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 商品库商品id tb_mall_goods.id
     */
    private Long goodsId;

    /**
     * 供应商id，tb_supplier.id
     */
    private Long supplierId;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 品牌名称
     */
    private String goodsBrand;

    /**
     * 商品描述
     */
    private String goodsDesc;

    /**
     * 商品类型1-实物 2-虚拟商品
     * @see GoodsTypeEnum
     */
    private Integer goodsType;

    /**
     * 商品类目id，tb_goods_category.id
     */
    private Long categoryId;

    /**
     * 商品主图id集合，逗号分割 对应tb_common_img.id
     */
    private String mainImgIds;

    /**
     * 商品主图id集合，逗号分割 对应tb_common_img.id
     */
    private String detailImgIds;

    /**
     * 业务id 业务类型为1时 直播id
     */
    private Long bizId;

    /**
     * 业务类型 1-直播
     * {@link cn.com.duiba.live.clue.service.api.enums.conf.mall.MallBizTypeEnum}
     */
    private Integer bizType;

    /**
     * 主标签
     */
    private String mainTag;

    /**
     * 副标签
     */
    private String subTag;

    /**
     * 是否支持七天无理由退货 0-不支持 1-支持
     * {@link cn.com.duiba.live.clue.service.api.enums.conf.BooleanEnum}
     */
    private Integer noReasonRefund;

    /**
     * 退货地址及联系方式等信息
     */
    private String refundInfo;

    /**
     * 最大购买数量限制
     */
    private Integer maxBuyNum;

    /**
     * 是否需要发货审核0-不需要 1-需要
     * {@link cn.com.duiba.live.clue.service.api.enums.conf.BooleanEnum}
     */
    private Integer deliveryAudit;

    /**
     * 限制购买地区编码
     */
    private String limitRegionCode;

    /**
     * 限制购买地区名称
     */
    private String limitRegionName;

    /**
     * 发货地
     */
    private String deliveryPlace;

    /**
     * 发货物流
     */
    private String expressCompany;

    /**
     * 按钮标题
     */
    private String buttonTitle;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}