package cn.com.duiba.live.clue.service.api.remoteservice.conf.admin;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.admin.LiveAdminCompanyRelatedDto;
import cn.com.duiba.live.clue.service.api.dto.conf.admin.LiveAdminDto;
import cn.com.duiba.live.clue.service.api.param.conf.admin.LiveAdminAuthCompanyQueryParam;
import cn.com.duiba.live.clue.service.api.param.conf.admin.LiveAdminChangeCompanyParam;
import cn.com.duiba.live.clue.service.api.param.conf.admin.LiveAdminCompanyAuthParam;
import cn.com.duiba.live.clue.service.api.param.conf.admin.LiveAdminSearchParam;

import java.util.List;

/**
 * 直播公司管理员服务
 * @author 周舟
 * @date 2020-3-28 10:22:31
 * @version 1.0
 */
@AdvancedFeignClient
public interface RemoteLiveAdminApiService {

    /**
     * 列表查询
     * @param queryParam 查询参数
     * @return 直播公司管理员集合
     */
    List<LiveAdminDto> findList(LiveAdminSearchParam queryParam);

    /**
     * 保存更新直播公司管理员
     * @param dto 直播公司管理员
     * @return 主键，为0，说明新增失败
     */
    Long save(LiveAdminDto dto);

    /**
     * 根据条件统计
     * @param param
     * @return
     */
    Integer countByCondition(LiveAdminSearchParam param);

    /**
     * 根据id删除
     * @param id 主键id
     * @return 是否成功 1 成功 其他失败
     */
    Integer deleteById(Long id);

    /**
     * 根据主键id查找
     * @param adminId
     * @return
     */
    LiveAdminDto findById(Long adminId);

    /**
     * 根据userID查询管理员
     * @param userId
     * @return
     */
    LiveAdminDto findByUserId(Long userId);

    /**
     * 根据管理员id 公司列表查询管理员对应的公司权限
     * @param adminId
     * @param companyIds
     * @return
     */
    List<LiveAdminCompanyRelatedDto> findAuthCompanyListByAdminId(Long adminId, List<Long> companyIds);

    /**
     * 保存直播管理员公司授权信息
     * @param adminId 管理员id
     * @param authParams 授权信息参数
     * @return
     */
    Boolean saveAdminAuth(Long adminId, List<LiveAdminCompanyAuthParam> authParams);

    /**
     * 根据条件统计公司/管理员关系列表数
     * @param param
     * @return
     */
    Integer countAdminCompanyRelatedByCondition(LiveAdminAuthCompanyQueryParam param);

    /**
     * 根据条件查询公司/管理员绑定关系列表
     * @param param
     * @return
     */
    List<LiveAdminCompanyRelatedDto> findAdminCompanyRelatedListByCondition(LiveAdminAuthCompanyQueryParam param);

    /**
     * 直播代理人切换公司
     * @param changeParam
     * @return
     */
    Boolean changeCompany(LiveAdminChangeCompanyParam changeParam);

    /**
     * 根据公司id查询所有的管理员直播用户id
     * @param companyId 公司id
     * @return 管理员直播用户id集合
     */
    List<Long> findUserIdsByCompanyId(Long companyId);

    /**
     * 根据公司id查找 公司下所有管理员列表
     * @param companyId
     * @return
     */
    List<LiveAdminDto> findByCompanyId(Long companyId);

    /**
     * 更新直播预览标识
     * @param previewFlag 直播预览标识 {@link cn.com.duiba.live.clue.service.api.enums.conf.agentConf.LiveAdminPreviewFlagEnum}
     * @param id 主键
     * @return 更新行数
     */
    Integer updatePreviewFlagById(Integer previewFlag, Long id);
}
