package cn.com.duiba.live.clue.service.api.remoteservice.conf.card;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.card.ApplyCardConfigDto;

import java.util.List;

/**
 * 银行卡入口配置
 *
 * @author ZhangJun
 * @date 2022/8/31 14:18
 */
@AdvancedFeignClient
public interface RemoteApplyCardConfigService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 银行卡入口配置
     */
    ApplyCardConfigDto selectById(Long id);

    /**
     * 根据直播查询
     *
     * @param liveId 直播id
     * @return 银行卡入口配置
     */
    List<ApplyCardConfigDto> findByLiveId(Long liveId);

    /**
     * 根据直播+入口类型查询
     *
     * @param liveId 主键
     * @param applyCardTypes 入口类型{@link cn.com.duiba.live.clue.service.api.enums.conf.card.ApplyCardTypeEnum}
     * @return 银行卡入口配置
     */
    List<ApplyCardConfigDto> findByLiveIdAndType(Long liveId, List<Integer> applyCardTypes);

    /**
     * 新增
     * @param dto 银行卡入口配置
     * @return 执行结果
     */
    boolean insert(ApplyCardConfigDto dto);

    /**
     * 批量新增
     *
     * @param dtos 配置
     * @return 执行结果
     */
    boolean batchInsert(List<ApplyCardConfigDto> dtos);

    /**
     * 更新
     * @param dto 银行卡入口配置
     * @return 执行结果
     */
    boolean update(ApplyCardConfigDto dto);

    /**
     * 批量更新
     *
     * @param dtos 配置
     * @return 执行结果
     */
    boolean batchUpdate(List<ApplyCardConfigDto> dtos);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    boolean delete(Long id);
}