package cn.com.duiba.live.clue.service.api.remoteservice.conf.card;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.card.BankCardActivityDto;
import cn.com.duiba.live.clue.service.api.param.conf.card.BankActivityPageParam;

import java.util.List;

/**
 * 银行办卡活动
 *
 * @author ZhangJun
 * @date 2022/8/31 14:03
 */
@AdvancedFeignClient
public interface RemoteBankCardActivityService {

    /**
     * 分页记录总数
     *
     * @param pageParam 分页参数
     * @return 记录总数
     */
    Long pageCount(BankActivityPageParam pageParam);

    /**
     * 分页列表
     *
     * @param pageParam 分页参数
     * @return 分页结果
     */
    List<BankCardActivityDto> pageList(BankActivityPageParam pageParam);

    /**
     * 根据公司查询所有
     *
     * @param companyId 公司id
     * @return 列表
     */
    List<BankCardActivityDto> listByCompanyId(Long companyId);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 银行卡活动配置
     */
    BankCardActivityDto selectById(Long id);

    /**
     * 批量根据主键查询
     *
     * @param ids 主键
     * @return 银行卡活动配置
     */
    List<BankCardActivityDto> listByIds(List<Long> ids);

    /**
     * 新增
     *
     * @param dto 银行卡活动配置
     * @return id
     */
    Long insert(BankCardActivityDto dto);

    /**
     * 更新
     *
     * @param dto 银行卡活动配置
     * @return 执行结果
     */
    boolean update(BankCardActivityDto dto);

    /**
     * 物理删除
     *
     * @param id 主键
     * @return 执行结果
     */
    boolean delete(Long id);
}