package cn.com.duiba.live.clue.service.api.remoteservice.conf.card;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.card.BankCardLinkConfDto;
import cn.com.duiba.live.clue.service.api.param.conf.card.BankCardLinkConfSearchParam;

import java.util.List;

/**
 * 银行卡链接配置
 *
 * @author ZhangJun
 * @date 2022/8/31 14:31
 */
@AdvancedFeignClient
public interface RemoteBankCardLinkConfService {

    /**
     * 获取分页总数 (管理后台)
     * @param param 查询参数（直播用户Id、直播Id、公司Id、活动Id）
     * @return 总记录数
     */
    Long selectCountBySearch(BankCardLinkConfSearchParam param);

    /**
     * 获取分页列表 (管理后台)
     * @param param 查询参数（直播用户Id、直播Id、公司Id、活动Id）
     * @return 列表
     */
    List<BankCardLinkConfDto> selectPageBySearch(BankCardLinkConfSearchParam param);


    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 银行卡链接配置
     */
    BankCardLinkConfDto selectById(Long id);

    /**
     * 批量根据主键查询
     *
     * @param ids 主键集合
     * @return 银行卡链接配置
     */
    List<BankCardLinkConfDto> listByIds(List<Long> ids);

    /**
     * 根据公司查询所有
     *
     * @param companyId 公司id
     * @param linkTypes 链接类型
     * @return 列表
     */
    List<BankCardLinkConfDto> listByCompanyIdAndLinkType(Long companyId, List<Integer> linkTypes);

    /**
     * 新增
     *
     * @param dto 银行卡链接配置
     * @return 执行结果
     */
    boolean insert(BankCardLinkConfDto dto);

    /**
     * 更新
     *
     * @param dto 银行卡链接配置
     * @return 执行结果
     */
    boolean update(BankCardLinkConfDto dto);

    /**
     * 物理删除
     *
     * @param id 主键
     * @return 执行结果
     */
    boolean delete(Long id);
}