package cn.com.duiba.live.clue.service.api.remoteservice.conf.choice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.choice.ChoiceAnswerDto;
import cn.com.duiba.live.clue.service.api.dto.conf.choice.ChoiceDetailDto;
import cn.com.duiba.live.clue.service.api.dto.conf.choice.ChoiceQuestionDto;
import cn.com.duiba.live.clue.service.api.param.conf.choice.ChoiceQuestionSearchParam;

import java.util.List;

/**
 * 测一测
 * @author lizhi
 * @date 2020/5/19 10:02 AM
 */
@AdvancedFeignClient
public interface RemoteChoiceApiService {

    /**
     * 保存测一测（包括答案）
     * @param detailDto 测一测详情，包含答案
     * @return 主键
     */
    Long saveOrUpdateDetail(ChoiceDetailDto detailDto);

    /**
     * 查询测一测详情（包含答案）
     * @param id 测一测问题ID
     * @return 测一测详情（包含答案）
     */
    ChoiceDetailDto findDetail(Long id);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 更新
     * @param dto 直播选择题库
     * @return 执行结果
     */
    int update(ChoiceQuestionDto dto);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播选择题库
     */
    ChoiceQuestionDto findById(Long id);

    /**
     * 根据主键集合查询
     * @param ids 主键集合
     * @return 直播选择题库集合
     */
    List<ChoiceQuestionDto> findByIds(List<Long> ids);

    /**
     * 分页查询
     * @param param 分页参数
     * @return 测一测列表
     */
    List<ChoiceQuestionDto> findPage(ChoiceQuestionSearchParam param);

    /**
     * 根据测一测问题ID查询答案列表
     * @param choiceQuestionIdList 问题ID问题集合
     * @return 答案列表
     */
    List<ChoiceAnswerDto> findAnswerByChoiceQuestionIds(List<Long> choiceQuestionIdList);

    /**
     * 根据公司ID查询未删除条数
     * @param companyId 公司ID
     * @return 条数
     */
    Integer countByCompanyId(Long companyId);
}
