package cn.com.duiba.live.clue.service.api.remoteservice.conf.conf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.conf.LiveAgentUrlRecordDto;
import cn.com.duiba.live.clue.service.api.param.conf.conf.LiveAgentUrlRecordQueryParam;

import java.util.List;

/**
 * 直播配置代理人专属链接记录服务rpc类
 */
@AdvancedFeignClient
public interface RemoteLiveAgentCustomUrlRecordApiService {

    /**
     * 根据直播id和资料id查询任务id
     *
     * @param param 查询条件
     * @return 直播资料代理人配置，应仅一条
     */
    Long findTaskIdByLiveResourceId(LiveAgentUrlRecordQueryParam param);

    /**
     * 批量插入
     *
     * @param list 需要批量插入的数据
     * @return 插入成功数量
     */
    Integer batchInsert(List<LiveAgentUrlRecordDto> list);

    /**
     * 根据任务id删除代理人专属链接记录
     *
     * @param liveId     直播id
     * @param resourceId 资料id
     * @param taskId     任务id
     * @return 删除成功数量
     */
    Long deleteByTaskId(Long liveId, Long resourceId, Long taskId);

    /**
     * 根据直播id、资料id、代理人工号查询记录
     *
     * @param liveId     直播id
     * @param resourceId 资料id
     * @param jobNumber  代理人工号
     * @return 代理人专属链接记录
     */
    LiveAgentUrlRecordDto findRecordByJobNumber(Long liveId, Long resourceId, String jobNumber);

    /**
     * 根据代理人工号查询专属链接记录
     *
     * @param liveId     直播id
     * @param resourceId 资料id
     * @param jobNumber  工号
     * @return 代理人专属链接记录
     */
    LiveAgentUrlRecordDto findByLiveIdResourceIdJobNumber(Long liveId, Long resourceId, String jobNumber);

    /**
     * 根据id删除
     *
     * @param id 主键did
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 新增或更新
     *
     * @param liveId     直播id
     * @param resourceId 资料id
     * @param jobNumber  工号
     * @param agentUrl   代理人链接
     * @return 主键id
     */
    Long saveOrUpdate(Long liveId, Long resourceId, String jobNumber, String agentUrl);

    /**
     * 根据id查询
     *
     * @param id 主键id
     * @return 代理人专属链接记录
     */
    LiveAgentUrlRecordDto findById(Long id);
}
