package cn.com.duiba.live.clue.service.api.remoteservice.conf.conf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.conf.LiveConfRewardPkDto;

import java.util.List;

/**
 * 直播配置奖励rpc服务
 *
 * @author 吴文哲
 * @date 2020-03-30 20:18
 **/
@AdvancedFeignClient
public interface RemoteLiveConfRewardPkApiService {


    /**
     * 根据直播ID和类型查询
     *
     * @param liveId     直播ID，不可为空
     * @param rewardType 奖励类型，1-个人，2-团队，可为空
     * @return 直播配置-pk奖励集合
     */
    List<LiveConfRewardPkDto> selectByLiveIdAndType(Long liveId, Integer rewardType);

    /**
     * 批量更新
     *
     * @param dtoList dto列表
     * @param liveId 直播间id
     * @param rewardType 奖励类型
     * @return
     */
    Integer batchUpdateReward(List<LiveConfRewardPkDto> dtoList, Long liveId, Integer rewardType);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播配置-pk奖励
     */
    LiveConfRewardPkDto selectById(Long id);

    /**
     * 批量新增
     * @param list 直播配置-pk奖励集合
     * @return 执行结果
     */
    int batchInsert(List<LiveConfRewardPkDto> list);

    /**
     * 物理删除
     * @param liveId 直播主键
     * @return 执行结果
     */
    int deleteByLiveId(Long liveId);
}
