package cn.com.duiba.live.clue.service.api.remoteservice.conf.conf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.conf.LiveConfSpecifyAwardStockDto;

/**
 * 直播间指定中奖配置 库存rpc服务
 * @author 吴文哲
 * @date 2020-09-09 14:24
 **/
@AdvancedFeignClient
public interface RemoteLiveConfSpecifyAwardStockApiService {

    /**
     * 根据直播间指定中奖配置id 查询库存
     * @param specConfId tb_live_conf_specify_conf.id
     * @return 指定中奖库存对象
     */
    LiveConfSpecifyAwardStockDto findBySpecifyAwardConfId(Long specConfId);

    /**
     * 新增库存信息
     *
     * @param entity
     * @return 主键
     */
    Long addStock(LiveConfSpecifyAwardStockDto entity);

    /**
     * 给指定中奖配置增加库存
     *
     * @param specifyAwardConfId 指定中奖配置id
     * @param stock              新增的库存
     * @return 影响行数
     */
    int increaseStock(Long specifyAwardConfId, int stock);

    /**
     * 给指定中奖配置减少库存
     *
     * @param specifyAwardConfId 指定中奖配置id
     * @param stock              库存
     * @return 影响行数
     */
    int decreaseStock(Long specifyAwardConfId, int stock);
}
