package cn.com.duiba.live.clue.service.api.remoteservice.conf.conf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.conf.LiveFissionLotteryConfDto;

import java.util.List;

/**
 * @author 郭浩
 * @Description 社交货币券配置RPC服务实现类
 * @date 2021/8/16 2:52 下午
 */
@AdvancedFeignClient
public interface RemoteLiveFissionLotteryConfService {
    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 直播裂变-社交抽奖券
     */
    LiveFissionLotteryConfDto findByIdFromCache(Long id);

    /**
     * 根据直播id查询
     *
     * @param liveId 直播id
     * @return 直播裂变-社交抽奖券
     */
    LiveFissionLotteryConfDto findByLiveIdFromCache(Long liveId);

    /**
     * 开启/关闭 社交抽奖券配置状态
     *
     * @param liveId     直播id
     * @param openStatus 0:关闭,1:开启
     * @return 执行结果
     * @see cn.com.duiba.live.clue.service.api.enums.conf.common.CommonConfigSwitchEnum
     */
    Boolean switchStatus(Long liveId, Integer openStatus);

    /**
     * 新增社交货币券配置
     *
     * @param dto 社交货币券配置
     * @return 执行结果
     */
    Boolean save(LiveFissionLotteryConfDto dto);

    /**
     * 修改社交货币券配置
     *
     * @param dto 社交货币券配置
     * @return 执行结果
     */
    Boolean update(LiveFissionLotteryConfDto dto);

    /**
     * 批量 根据直播id查询
     *
     * @param liveIds 直播id
     * @return 直播裂变-社交抽奖券
     */
    List<LiveFissionLotteryConfDto> findConfByLiveIds(List<Long> liveIds);
}
