package cn.com.duiba.live.clue.service.api.remoteservice.conf.conf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.lottery.LiveLotteryRegionConfDto;

import java.util.List;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2021/2/6 18:34
 */
@AdvancedFeignClient
public interface RemoteLiveLotteryRegionConfService {

    /**
     * 根据直播id和抽奖配置id和状态查询
     * @param liveId 直播id
     * @param confId 抽奖配置id,可不传
     * @param confStatus 状态，可不传，查全部状态
     * @return 直播抽奖中奖规则配置
     */
    List<LiveLotteryRegionConfDto> selectByLiveAndConf(Long liveId, Long confId, Integer confStatus);

    /**
     * 新增
     * @param list 直播抽奖中奖规则配置
     * @return 执行结果
     */
    int batchDeleteAndInsert(List<LiveLotteryRegionConfDto> list);

    /**
     * 根据直播id和抽奖配置id更新状态
     * @param liveId
     * @param confId
     * @param confStatus
     * @return
     */
    int updateStatusByLiveIdAndConfId(Long liveId, Long confId, Integer confStatus);

    /**
     * 根据主键查询
     * @param id
     * @return
     */
    LiveLotteryRegionConfDto findById(Long id);

    /**
     * 根据主键删除
     * @param id
     * @return
     */
    int deleteById(Long id);

    /**
     * 根据直播Id、配置id、省份code删除记录
     * @param liveId
     * @param confId
     * @param provinceCode
     * @return
     */
    int deleteByLiveConfigProvince(Long liveId, Long confId, Integer provinceCode);

    /**
     * 根据直播id、配置id查询状态
     * @param liveId
     * @param confId
     * @return
     */
    Integer selectStatusByLiveConfId(Long liveId, Long confId);

}
