package cn.com.duiba.live.clue.service.api.remoteservice.conf.duiba;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.duiba.DuibaAppDto;

import java.util.List;

/**
 * 兑吧积分商城配置
 * @author lizhi
 * @date 2022/11/30 10:09 上午
 */
@AdvancedFeignClient
public interface RemoteDuibaAppService {

    /**
     * 查询所有配置
     * @return 兑吧积分商城配置集合
     */
    List<DuibaAppDto> selectAllList();

    /**
     * 根据积分商城appKey查询(redis缓存1天)
     * @param appKey 积分商城appKey
     * @return 兑吧积分商城配置
     */
    DuibaAppDto selectByAppKeyCache(String appKey);

    /**
     * 新增
     * @param entity 兑吧积分商城配置
     * @return 执行结果
     */
    int insert(DuibaAppDto entity);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}
