package cn.com.duiba.live.clue.service.api.remoteservice.conf.evaluation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.evaluation.EvaluationQuestionOptionDto;

import java.util.List;

/**
 * 选项
 *
 * @author xuzhigang
 * @date 2021/8/27 3:31 下午
 **/
@AdvancedFeignClient
public interface RemoteEvaluationQuestionOptionService {
    /**
     * 根据问题ids批量查询
     *
     * @param questionIds 问题id集合
     * @return 选项集合
     */
    List<EvaluationQuestionOptionDto> findByQuestionIds(List<Long> questionIds);

    /**
     * 根据id集合批量查询
     *
     * @param ids ids
     * @return 选项列表
     */
    List<EvaluationQuestionOptionDto> findByIds(List<Long> ids);
}
