package cn.com.duiba.live.clue.service.api.remoteservice.conf.form;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.form.FormDto;
import cn.com.duiba.live.clue.service.api.param.conf.form.FormSearchParam;

import java.util.List;

/**
 * 表单rpc服务
 *
 * @author xuzhigang
 * @date 2020/7/27 4:27 下午
 **/
@AdvancedFeignClient
public interface RemoteFormApiService {
    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 单集合
     */
    List<FormDto> selectList(FormSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(FormSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 单
     */
    FormDto selectById(Long id);

    /**
     * 根据业务id和业务类型查询
     *
     * @param bizId 业务id
     * @param bizType 业务类型
     * @return 集合
     */
    List<FormDto> selectByBizIdAndBizType(Long bizId, Integer bizType);

    /**
     * 批量insert
     *
     * @param list 表单集合
     * @return 执行结果
     */
    int batchInsertGeneratedKeys(List<FormDto> list);

    /**
     * 批量更新
     *
     * @param list 表单集合
     * @return 执行结果
     */
    int batchUpdate(List<FormDto> list);

    /**
     * 批量删除
     *
     * @param ids 主键集合
     * @return 执行结果
     */
    int batchDelete(List<Long> ids);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}
