package cn.com.duiba.live.clue.service.api.remoteservice.conf.form;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.form.PubFormConfDetailDto;
import cn.com.duiba.live.clue.service.api.dto.conf.form.PubFormConfDto;
import cn.com.duiba.live.clue.service.api.param.common.PageQuery;
import cn.com.duiba.live.clue.service.api.param.conf.form.PubFormSelectParam;

import java.util.List;

/**
 * @author zhuenhui
 * @date 2021/09/29 16:20
 * @description 公域流量 - 表单测试 RPC Service
 */
@AdvancedFeignClient
public interface RemotePubFormConfApiService {

    /**
     * 分页查询列表 ( 管理后台专用 )
     *
     * @param param 查询参数
     * @return 测试列表
     */
    @Deprecated
    List<PubFormConfDto> selectPage(PageQuery param);

    /**
     * 按照条件查询 ( 管理后台专用 )
     * @param param 查询参数
     * @return 测试列表
     */
    List<PubFormConfDto> selectPageWithType(PubFormSelectParam param);

    /**
     * 通过条件查询记录的总记录数 ( 管理后台专用 )
     *
     * @param params 查询参数
     * @return 总记录数
     */
    Long selectCountByType(PubFormSelectParam params);

    /**
     * 查询记录的总记录数 ( 管理后台专用 )
     *
     * @return 总记录数
     */
    @Deprecated
    Long selectCount();

    /**
     * 获取表单配置详情 Redis -> DB
     *
     * @param id 表单Id
     * @return 配置详情
     */
    PubFormConfDto findByIdWithCache(Long id);

    /**
     * 新增/更新配置
     *
     * @param confDto 公域流量 - 表单测试配置
     * @return 表单Id
     */
    Long saveOrUpdate(PubFormConfDetailDto confDto);

    /**
     * 逻辑删除
     *
     * @param id 表单Id
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 更新表单状态
     *
     * @param id     表单Id
     * @param status 目标状态
     *               {@link cn.com.duiba.live.clue.service.api.enums.conf.form.PubFormStatusEnum}
     * @return 执行结果
     */
    int updateStatus(Long id, Integer status);


    /**
     * 根据主键id查询
     *
     * @param ids id集合
     * @return 查询结果
     */
    List<PubFormConfDto> listByIds(List<Long> ids);

    /**
     * 查询所有
     * 管理后台专用
     */
    List<PubFormConfDto> listAll();

    /**
     * 更新表单所属公司
     *
     * @param id  表单id
     * @param companyId 公司id
     * @return 更新结果
     */
    boolean updateFormCompany(Long id, Long companyId);

    /**
     * 批量更新表单所属公司
     * 管理后台刷数据专用
     *
     * @param ids 表单id集合
     * @param companyId 公司id
     * @return 更新结果
     */
    boolean batchUpdateFormCompany(List<Long> ids, Long companyId);

    /**
     * 变更回传状态
     * @param formId 表单id
     * @param autoCallback 自动回传状态 0关闭 1开启
     * @return 变更后的回传状态
     */
    Integer callbackStatusChange(Long formId, Integer autoCallback);
}
