package cn.com.duiba.live.clue.service.api.remoteservice.conf.fortune;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author gxy
 * @date 2021/7/6 3:02 下午
 */
@AdvancedFeignClient
public interface RemoteFortuneApiService {

    /**
     * 根据直播id查询好运红包概率，存到redis7天
     *
     * @param liveId 直播id
     * @return 红包概率
     */
    Integer getProbabilityByLiveId(Long liveId);

    /**
     * 分配好运红包redis库存
     * @param redType 类型
     * @param redPacketId 红包id
     * @param num 数量
     * @param amount 总额
     * @return 分配结果
     */
    boolean setFortuneRedStock(Integer redType, Long redPacketId, Integer num, Integer amount);

    /**
     * 清除好运红包现金概率缓存
     * @param liveId 直播id
     * @return 操作结果
     */
    boolean clearProbabilityCache(Long liveId);

}
