package cn.com.duiba.live.clue.service.api.remoteservice.conf.goods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.goods.LiveGoodsDto;

import java.util.List;

/**
 * @author guoxuebiao
 * @date 2021/8/10 4:08 下午
 */
@AdvancedFeignClient
public interface RemoteLiveGoodsApiService {

    /**
     * 查询公司下的所有商品列表（助播端使用）
     * @param companyId 公司id
     * @return 商品列表
     */
    List<LiveGoodsDto> findList(Long companyId);

    /**
     * 分页查询公司下的商品列表（管理端分页使用）
     * @param companyId 公司id
     * @param pageNo 页码
     * @param pageSize 页数
     * @return 商品列表
     */
    List<LiveGoodsDto> findPage(Long companyId, int pageNo, int pageSize);

    /**
     * 查询公司下的商品数量（管理端分页专用）
     * @param companyId 公司id
     * @return 商品数量
     */
    long findCount(Long companyId);

    /**
     * 保存商品
     * @param liveGoodsDto 商品实体
     * @return 操作条数
     */
    int insert(LiveGoodsDto liveGoodsDto);

    /**
     * 更新商品
     * @param liveGoodsDto 商品实体
     * @return 操作条数
     */
    int update(LiveGoodsDto liveGoodsDto);

    /**
     * 根据商品id查询商品
     * @param id 商品id
     * @return 商品详情
     */
    LiveGoodsDto findById(Long id);

    /**
     * 根据id集合批量查询
     *
     * @param ids id集合
     * @return 商品集合
     */
    List<LiveGoodsDto> selectByIds(List<Long> ids);

    /**
     * 根据商品id删除
     * @param id 商品id
     * @return 操作条数
     */
    int delete(Long id);
}
