package cn.com.duiba.live.clue.service.api.remoteservice.conf.kill;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.kill.LiveKillGoodsDetailDto;
import cn.com.duiba.live.clue.service.api.dto.conf.kill.LiveSecondKillGoodsDto;
import cn.com.duiba.live.clue.service.api.dto.conf.kill.LiveSecondKillGoodsSaveDto;
import cn.com.duiba.live.clue.service.api.dto.conf.kill.LiveSecondKillGoodsUpdateDto;

import java.util.List;

/**
 * @author guoxuebiao
 * @date 2021/8/10 7:47 下午
 */
@AdvancedFeignClient
public interface RemoteLiveGoodsSecondKillApiService {

    /**
     * 查询直播下的所有秒杀商品列表 redis缓存2min
     * @param liveId 直播id
     * @return 所有秒杀商品列表
     */
    List<LiveSecondKillGoodsDto> findListWithCache(Long liveId);

    /**
     * 根据confId商品详情 redis缓存2min
     * @param confId 配置id
     * @return 商品详情
     */
    LiveKillGoodsDetailDto findGoodsDetailByConfIdCache(Long confId);

    /**
     * 根据confId查询商品详情
     * @param confId 配置id
     * @return 商品详情
     */
    LiveKillGoodsDetailDto findGoodsDetailByConfId(Long confId);

    /**
     * 查询直播下的所有秒杀商品列表
     * @param liveId 直播id
     * @return 所有秒杀商品列表
     */
    List<LiveSecondKillGoodsDto> findList(Long liveId);

    /**
     * 根据秒杀商品id删除
     * @param id 秒杀商品id
     * @return 成功条数
     */
    int deleteById(Long id);

    /**
     * 保存秒杀商品
     * @param dto 秒杀商品实体
     * @return 秒杀商品id
     */
    Long save(LiveSecondKillGoodsSaveDto dto);

    /**
     * 保存秒杀商品
     * @param dto 秒杀商品实体
     * @return 成功条数
     */
    int update(LiveSecondKillGoodsUpdateDto dto);

    /**
     * 上架秒杀商品
     * @param id 秒杀商品id
     * @return 是否成功
     */
    boolean on(Long id);

    /**
     * 下架秒杀商品
     * @param id 秒杀商品id
     * @return 是否成功
     */
    boolean off(Long id);

    /**
     * 秒杀限制组
     *
     * @param liveId 直播id
     * @param confIds 秒杀商品配置id集合
     * @return true-保存成功 false-保存失败
     */
    boolean saveLimitGroup(Long liveId, List<Long> confIds);

    /**
     * 根据直播id查询秒杀限制商品组
     *
     * @param liveId 直播id
     * @return 秒杀限制商品confId集合
     */
    List<Long> limitGroupList(Long liveId);

    /**
     * 根据直播id查询秒杀限制商品组
     * redis缓存 10分钟
     *
     * @param liveId 直播id
     * @return 秒杀限制商品confId集合
     */
    List<Long> limitGroupListWithCache(Long liveId);
}
