package cn.com.duiba.live.clue.service.api.remoteservice.conf.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.live.LiveSeriesPosterDto;
import cn.com.duiba.live.clue.service.api.param.conf.live.LiveSeriesPosterParam;

import java.util.List;

/**
 * @author ZhangJun
 * @date 2021/6/17 2:37 下午
 */
@AdvancedFeignClient
public interface RemoteLiveSeriesPosterService {

    /**
     * 更新直播系列海报
     *
     * @param liveId 直播id
     * @param params 海报集合
     * @return 操作结果
     */
    int saveOrUpdate(Long liveId, List<LiveSeriesPosterParam> params);

    /**
     * 根据直播id查询系列海报
     *
     * @param liveId 直播id
     * @return 海报集合
     */
    List<LiveSeriesPosterDto> findByLiveId(Long liveId);

}
