package cn.com.duiba.live.clue.service.api.remoteservice.conf.live.home;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.live.home.LiveCompanyHomeDto;
import cn.com.duiba.live.clue.service.api.param.conf.live.home.LiveCompanyHomeSearchParam;

import java.util.List;

/**
 * @author zhuenhui
 * @date 2022/07/21 14:39
 * @description 直播公司首页 - RPC接口
 */
@AdvancedFeignClient
public interface RemoteLiveCompanyHomeApiService {


    /**
     * 根据条件查询，不分页
     *
     * @param param 查询条件
     * @return 直播公司首页集合
     */
    List<LiveCompanyHomeDto> selectList(LiveCompanyHomeSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     *
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(LiveCompanyHomeSearchParam param);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 直播公司首页
     */
    LiveCompanyHomeDto selectById(Long id);

    /**
     * 根据公司Id查询
     *
     * @param companyId 公司Id
     * @return 直播公司首页
     */
    LiveCompanyHomeDto selectByCompanyId(Long companyId);

    /**
     * 新增
     *
     * @param dto 直播公司首页
     * @return 执行结果
     */
    int insert(LiveCompanyHomeDto dto);

    /**
     * 更新
     *
     * @param dto 直播公司首页
     * @return 执行结果
     */
    int update(LiveCompanyHomeDto dto);

    /**
     * 更新开启状态
     *
     * @param id        主键Id
     * @param oldStatus 以前的状态
     * @param status    更新状态
     *                  {@link cn.com.duiba.live.clue.service.api.enums.conf.BooleanEnum}
     * @return 更新结果
     */
    int updateStatusById(Long id, Integer oldStatus, Integer status);

    /**
     * 更新默认状态
     *
     * @param id        主键Id
     * @param oldStatus 以前的状态
     * @param status    更新状态
     *                  {@link cn.com.duiba.live.clue.service.api.enums.conf.BooleanEnum}
     * @return 更新结果
     */
    int updateDefaultStatusById(Long id, Integer oldStatus, Integer status);

    /**
     * 软删
     *
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}
