package cn.com.duiba.live.clue.service.api.remoteservice.conf.livestream;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.livestream.TranscribeRecordDto;
import cn.com.duiba.live.clue.service.api.param.conf.livestream.TranscribeAddParam;

import java.util.List;

/**
 * Created by dugq on 2020-04-10.
 */
@AdvancedFeignClient
public interface RemoteAliyunTranscribeApiService {
    /**
     * 查询直播流下的所有视频
     * @param streamId
     * @return
     */
    List<TranscribeRecordDto> selectList(Long streamId);

    /**
     * 查询直播流下的所有视频的数量
     * @param streamId
     * @return
     */
    Integer selectCount(Long streamId);


    /**
     * 新增直播流
     * @return 记录ID
     */
    Long add(TranscribeAddParam param);

    /**
     * 跟新地址
     * 提供给腾讯云的录制回调使用
     * 由于腾讯云存储单独计费，所以异步迁移到阿里云存储
     * @param cdnUrl 阿里云oss 请手动填充为完整地址（以http开头）
     */
    int updateUrl(Long id, String cdnUrl);

    /**
     * 停止录制
     * @param streamId 流id
     * @return true-成功 false-失败
     */
    boolean stopTranscribe(Long streamId);
}
