package cn.com.duiba.live.clue.service.api.remoteservice.conf.livestream;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.livestream.LiveAppDto;
import cn.com.duiba.live.clue.service.api.dto.conf.livestream.LivePlayPlatformDto;
import cn.com.duiba.live.clue.service.api.dto.conf.livestream.NewStreamResultDto;
import cn.com.duiba.live.clue.service.api.dto.conf.livestream.StreamUrlDto;

import java.util.List;

/**
 * @author dugq
 * @date 2020-09-23 14:51
 */
@AdvancedFeignClient
public interface RemoteLivePlayApiService {

    /**
     * 自由选择appID进行直播间的创建
     * @param appId appId
     * @return 推流信息
     */
    NewStreamResultDto createNewLiveStream(Long appId);

    /**
     * 根据直播ID查询直播流相关信息。
     * @param liveId 直播ID
     * @return 直播流的推流地址和平台
     */
    LivePlayPlatformDto findLivePlayDetailByLiveId(Long liveId);

    /**
     * 查询直播流的app列表。
     * 直播流都是挂载在app下的。不管是腾讯云还是阿里云都是如此设计
     * @deprecated 后续使用#selectListByBizType
     */
    @Deprecated
    List<LiveAppDto> findLiveAppList();

    /**
     * 根据业务类型查询
     *
     * @param bizType 业务类型 {@link cn.com.duiba.live.clue.service.api.enums.conf.live.BizTypeApiEnum}
     * @return app信息
     */
    List<LiveAppDto> selectListByBizType(Integer bizType);

    /**
     *根据直播ID获取正在使用的平台
     */
    Integer getPlatformByLiveId(Long liveId);

    /**
     * 获取流在指定app下的拉流列表
     * 10 分钟缓存。
     * @param liveId  直播ID
     * @param streamAppId aliyun_app 表ID   streamAppId == null 时查询正在使用的拉流列表。此时不走缓存。调用方可选择短暂缓存。
     * @return
     */
    List<StreamUrlDto> getPullUrlListWithCache(Long liveId, Long streamAppId);

    /**
     * 获取流正在使用的stream app id
     */
    Long getStreamAppId(Long streamId);

    /**
     * 变更流使用的app
     */
    int changeStreamPlatform(Long streamId,Long liveAppId);
}
