package cn.com.duiba.live.clue.service.api.remoteservice.conf.lottery;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.lottery.LiveLotteryTeamConfDto;
import cn.com.duiba.live.clue.service.api.param.common.PageQuery;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 直播抽奖-团队份数配置
 * @author lizhi
 * @date 2021/5/8 9:55 上午
 */
@AdvancedFeignClient
public interface RemoteLiveLotteryTeamConfService {

    /**
     * 新增
     * @param dto 直播抽奖-团队份数配置
     * @return 执行结果
     */
    int insertAndAddExtNum(LiveLotteryTeamConfDto dto);

    /**
     * 批量新增
     * @param liveId 直播ID
     * @param confId 直播抽奖配置ID
     * @param teamTotalNumMap key：teamId，value：totalNum
     * @return 执行结果
     */
    int batchInsertAndAddExtNum(Long liveId, Long confId, Map<Long, Integer> teamTotalNumMap);

    /**
     * 更新
     * @param id 主键
     * @param totalNum 奖品份数
     * @return 执行结果
     */
    int updateTotalNumAndExtNum(Long id, Integer totalNum);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int deleteAndSubExtNum(Long id);

    /**
     * 批量物理删除
     * @param ids 主键集合
     * @return 执行结果
     */
    int batchDeleteAndSubExtNum(List<Long> ids);

    /**
     * 根据条件查询，不分页
     * @param liveId 直播ID
     * @param confId 配置ID
     * @param pageQuery 分页参数
     * @return 直播抽奖-团队份数配置集合
     */
    List<LiveLotteryTeamConfDto> selectPage(Long liveId, Long confId, PageQuery pageQuery);

    /**
     * 查询已经配置的团队ID
     * @param liveId 直播ID
     * @param confId 配置ID
     * @param teamIds 团队ID集合
     * @return 已经配置的团队ID
     */
    Set<Long> selectExistTeamIds(Long liveId, Long confId, List<Long> teamIds);

    /**
     * 根据团队ID，查询所有的主键
     * @param teamId 团队ID
     * @return 团队ID对应的所有主键
     */
    List<Long> selectIdsByTeamId(Long teamId);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播抽奖-团队份数配置
     */
    LiveLotteryTeamConfDto selectById(Long id);

    /**
     * 管理后台分页查询专用-根据条件,查询记录的总记录数
     * @param liveId 直播ID
     * @param confId 配置ID
     * @return 符合条件的记录数
     */
    long selectCount(Long liveId, Long confId);

    /**
     * 管理后端专用，批量查询直播下所有奖品总记录数
     * @param liveId 直播ID
     * @return key：confId，value：配置的团队数
     */
    Map<Long, Long> selectConfIdCountMap(Long liveId);
}
