package cn.com.duiba.live.clue.service.api.remoteservice.conf.mall.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.mall.activity.MallPickActivityDto;
import cn.com.duiba.live.clue.service.api.param.conf.mall.activity.MallPickActivityPageEsParam;
import cn.com.duiba.live.clue.service.api.param.conf.mall.activity.MallPickActivityPageParam;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;

/**
 * 商城-选品活动
 *
 * @author kjj mybatis generator 
 * @date 2022-07-27
 */
@AdvancedFeignClient
public interface RemoteMallPickActivityService {

    /**
     * es刷数据脚本
     */
    void esScript();
     
    /**
     * 查询所有
     *
     * @return 商城-选品活动集合
     */
    List<MallPickActivityDto> listAll();

    /**
     * 分页查询
     *
     * @param param  分页查询条件
     * @return 分页结果
     */
    List<MallPickActivityDto> pageList(MallPickActivityPageParam param);

    /**
     * 分页查询 es
     *
     * @param param  分页查询条件
     * @return 分页结果
     */
    Pair<Long,List<MallPickActivityDto>> pageListEs(MallPickActivityPageEsParam param);

    /**
     * 分页总条数
     *
     * @return 数量
     */
    Long pageCount(MallPickActivityPageParam param);

    /**
     * 统计所有记录数量
     *
     * @return 数量
     */
    Long countAll();

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 商城-选品活动
     */
    MallPickActivityDto selectById(Long id);

    /**
     * 批量根据主键集合查询
     *
     * @param ids 主键集合
     * @return 商城-选品活动
     */
    List<MallPickActivityDto> selectByIds(List<Long> ids);

    /**
     * 新增
     *
     * @param dto 商城-选品活动
     * @return 执行结果
     */
    boolean insert(MallPickActivityDto dto);

    /**
     * 更新
     *
     * @param dto 商城-选品活动
     * @return 执行结果
     */
    boolean update(MallPickActivityDto dto);
}