package cn.com.duiba.live.clue.service.api.remoteservice.conf.mall.common;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.common.CommonImgDto;

import java.util.List;

/**
 * 远程公共图片服务
 *
 * @author zouwx
 * @date 2022/07/29
 */
@AdvancedFeignClient
public interface RemoteCommonImageService {

    /**
     * 新增
     *
     * @param dto 通用图片
     * @return 新增结果
     */
    Long insert(CommonImgDto dto);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 图片信息
     */
    CommonImgDto selectById(Long id);

    /**
     * 根据主键批量查询
     *
     * @param ids 主键id
     * @return 图片列表
     */
    List<CommonImgDto> listByIds(List<Long> ids);
}
