package cn.com.duiba.live.clue.service.api.remoteservice.conf.mall.goods.pick;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.mall.goods.pick.MallPickGoodsDto;
import cn.com.duiba.live.clue.service.api.param.conf.mall.thirdparty.PickGoodsPageParam;

import java.util.List;

/**
 * 商城-选品库
 *
 * @author kjj mybatis generator 
 * @date 2022-07-27
 */
@AdvancedFeignClient
public interface RemoteMallPickGoodsService {
     
    /**
     * 根据选品活动分页查询选品
     *
     * @param pickActivityId 查询条件
     * @param offset 偏移量
     * @param pageSize 分页大小
     * @return 商城-选品库集合
     */
    List<MallPickGoodsDto> pageListByActivity(Long pickActivityId, Integer offset, Integer pageSize);

    /**
     * 根据选品活动id集合批量查询选品
     *
     * @param activityIds 选品活动id
     * @return 选品集合
     */
    List<MallPickGoodsDto> listByActivityIds(List<Long> activityIds);

    /**
     * 根据条件,查询记录的总记录数
     *
     * @param pickActivityId 选品活动id
     * @return 符合条件的记录数
     */
    Long countByActivity(Long pickActivityId);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 商城-选品库
     */
    MallPickGoodsDto selectById(Long id);

    /**
     * 新增
     *
     * @param dto 商城-选品库
     * @return 执行结果
     */
    boolean insert(MallPickGoodsDto dto);

    /**
     * 批量新增
     *
     * @param dtos 选品集合
     * @return 新增结果
     */
    boolean batchInsert(List<MallPickGoodsDto> dtos);

    /**
     * 更新
     *
     * @param dto 商城-选品库
     * @return 执行结果
     */
    boolean update(MallPickGoodsDto dto);

    /**
     * 物理删除
     *
     * @param id 主键
     * @return 执行结果
     */
    boolean delete(Long id);

    /**
     * 批量删除
     *
     * @param ids 主键id集合
     * @return 删除结果
     */
    boolean deleteByIds(List<Long> ids);

    /**
     * 修改选品状态
     *
     * @param id  选品id
     * @param oldPickStatus  选品的当前状态
     * @param newPickStatus 修改后的状态
     * @return 修改结果
     */
    boolean updatePickStatus(Long id, Integer oldPickStatus, Integer newPickStatus);

    // ------------------------- 以下为供应商侧操作专用 ----------------------------

    /**
     * 供应商侧-选品分页列表
     *
     * @param param 分页参数
     * @return 分页结果
     */
    List<MallPickGoodsDto> thirdGoodsPageList(PickGoodsPageParam param);

    /**
     * 供应商侧-统计选品数量
     *
     * @param param 筛选条件
     * @return 选品数量
     */
    Long thirdGoodsCount(PickGoodsPageParam param);

    /**
     * 供应商-选品信息
     *
     * @param id 选品id
     * @param supplierId 供应商id
     * @return 选品信息
     */
    MallPickGoodsDto findByIdAndSupplier(Long id, Long supplierId);
}