package cn.com.duiba.live.clue.service.api.remoteservice.conf.mall.marketing;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.mall.marketing.MallMarketingActivityDto;
import cn.com.duiba.live.clue.service.api.param.conf.mall.marketing.MallMarketingActivitySearchParam;

import java.util.List;

/**
 * @author xuzhigang
 * @date 2023/6/8 11:26
 **/
@AdvancedFeignClient
public interface RemoteMallMarketingActivityService {
    /**
     * 根据条件查询
     * @param param 查询条件
     * @return 商品营销活动配置集合
     */
    List<MallMarketingActivityDto> selectList(MallMarketingActivitySearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(MallMarketingActivitySearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 商品营销活动配置
     */
    MallMarketingActivityDto selectById(Long id);

    /**
     * 新增
     * @param dto 商品营销活动配置
     * @return 执行结果
     */
    int insert(MallMarketingActivityDto dto);

    /**
     * 更新
     * @param dto 商品营销活动配置
     * @return 执行结果
     */
    int update(MallMarketingActivityDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}